//+------------------------------------------------------------------+
//|                                               2MA_Lib_Sample.mq4 |
//|                                       Copyright  2009, TheXpert |
//|                                           theforexpert@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, TheXpert"
#property link      "theforexpert@gmail.com"

#include <Indicator_Painting.mqh>

#property indicator_chart_window

#property indicator_buffers 8

#property indicator_color1 Maroon
#property indicator_color2 Coral
#property indicator_color3 Navy
#property indicator_color4 Navy
#property indicator_color5 DeepSkyBlue
#property indicator_color6 DeepSkyBlue
#property indicator_color7 Gold
#property indicator_color8 White

#property indicator_width1 3
#property indicator_width2 3
#property indicator_width3 3
#property indicator_width4 3
#property indicator_width5 3
#property indicator_width6 3
#property indicator_width7 3
#property indicator_width8 3

extern int SlowPeriod      = 40;
extern int FastPeriod      = 15;
extern bool MarkFastDirections = true;
extern bool MarkSlowDirections = true;
extern bool MarkFastExtremums = true;
extern bool MarkCrosses = true;

// buffers
double FastValues[];
double SlowValues[];
double FastGrowing1[];
double FastGrowing2[];
double SlowGrowing1[];
double SlowGrowing2[];
double FastExtremums[];
double Crosses[];

int DigitsUsed = 6;
int EmptyValueUsed = 0;

int init()
{
   SetIndexBuffer(0, FastValues);
   SetIndexBuffer(1, SlowValues);
   
   // buffers for marking directions
   SetIndexBuffer(2, FastGrowing1);
   SetIndexBuffer(3, FastGrowing2);
   
   SetIndexBuffer(4, SlowGrowing1);
   SetIndexBuffer(5, SlowGrowing2);

   // buffers for marking extremums
   SetIndexBuffer(6, FastExtremums);
   // buffers for marking crosses
   SetIndexBuffer(7, Crosses);
   
   // buffer settings
   SetIndexStyle(0, DRAW_LINE);
   SetIndexStyle(1, DRAW_LINE);
   SetIndexStyle(2, DRAW_LINE);
   SetIndexStyle(3, DRAW_LINE);
   SetIndexStyle(4, DRAW_LINE);
   SetIndexStyle(5, DRAW_LINE);
   SetIndexStyle(6, DRAW_ARROW, STYLE_SOLID, 2);
   SetIndexStyle(7, DRAW_ARROW, STYLE_SOLID, 2);
   
   SetIndexArrow(6, 159);
   SetIndexArrow(7, 251);

   return(0);
}

int start()
{
   int toCount = Bars - IndicatorCounted();  
   
   for (int i = toCount - 1; i >=0; i--)
   {
      FastValues[i] = NormalizeDouble(iMA(Symbol(), 0, FastPeriod, 0, MODE_EMA, PRICE_CLOSE, i), DigitsUsed);
      SlowValues[i] = NormalizeDouble(iMA(Symbol(), 0, SlowPeriod, 0, MODE_EMA, PRICE_CLOSE, i), DigitsUsed);
   }
      
   if (MarkCrosses)
   {
      MarkCrosses(FastValues, SlowValues, Crosses, toCount - 1, 0, CROSS_ALL, EmptyValueUsed);
   }
   
   if (MarkFastDirections) 
   {
      MarkGrowing(FastValues, FastGrowing1, FastGrowing2, toCount - 1, 0, EmptyValueUsed);
   }
   
   if (MarkSlowDirections) 
   {
      MarkGrowing(SlowValues, SlowGrowing1, SlowGrowing2, toCount - 1, 0, EmptyValueUsed);
   }
   
   if (MarkFastExtremums)
   {
      MarkExtremums(FastValues, FastExtremums, toCount - 1, 0, DIR_ALL, EmptyValueUsed);
   }

   return(0);
}