//+------------------------------------------------------------------+
//|                                     RSI_Extremums_Lib_Sample.mq4 |
//|                                       Copyright  2009, TheXpert |
//|                                           theforexpert@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, TheXpert"
#property link      "theforexpert@gmail.com"

#include <Indicator_Painting.mqh>

#property indicator_separate_window

#property indicator_buffers 2

#property indicator_minimum 0
#property indicator_maximum 100

#property indicator_color1  White
#property indicator_color2  Red

extern int RSIPeriod       = 9;
extern int AppliedPrice    = 0;

// buffers
double Values[];           
double Extremums[];        

int DigitsUsed = 5;
int EmptyValueUsed = 0;

int init()
{
   SetIndexBuffer(0, Values);
   SetIndexBuffer(1, Extremums);
   
   SetIndexStyle(0, DRAW_LINE);     

   SetIndexStyle(1, DRAW_ARROW, STYLE_SOLID, 2);
   SetIndexArrow(1, 159);
   
   IndicatorDigits(DigitsUsed);
   
   SetIndexDrawBegin(0, RSIPeriod);
   SetIndexDrawBegin(1, RSIPeriod + 2);

   return(0);
}

int start()
{
   int toCount = Bars - IndicatorCounted();  

   for (int i = toCount - 1; i >=0; i--)
   {
      Values[i] = NormalizeDouble(iRSI(Symbol(), 0, RSIPeriod, AppliedPrice, i), DigitsUsed);
   }
   
   MarkExtremums(Values, Extremums, toCount - 1, 0, DIR_ALL, EmptyValueUsed);
   
   return(0);
}