//+------------------------------------------------------------------+
//|                                           RSI_Crosses_Sample.mq4 |
//|                                       Copyright  2009, TheXpert |
//|                                           theforexpert@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, TheXpert"
#property link      "theforexpert@gmail.com"

#property indicator_separate_window

#property indicator_buffers 3

#property indicator_minimum 0
#property indicator_maximum 100

#property indicator_color1  White
#property indicator_color2  Red
#property indicator_color3  Blue

extern int RSIPeriod       = 9;
extern int AppliedPrice    = 0;
extern int MAPeriod        = 5;

// buffers
double Values[];           // values
double SmoothedValues[];   // smoothed values
double Crosses[];          // crosses

int DigitsUsed = 5;
int EmptyValueUsed = 0;

int init()
{
   SetIndexBuffer(0, Values);
   SetIndexBuffer(1, SmoothedValues);
   SetIndexBuffer(2, Crosses);
   
   // buffers settings
   SetIndexStyle(0, DRAW_LINE);     
   SetIndexStyle(1, DRAW_LINE, STYLE_DASH); 
   SetIndexStyle(2, DRAW_ARROW, STYLE_SOLID, 2); 
   
   SetIndexArrow(2, 251);
   
   IndicatorDigits(DigitsUsed);
   
   SetIndexDrawBegin(0, RSIPeriod);
   SetIndexDrawBegin(1, RSIPeriod + MAPeriod);
   SetIndexDrawBegin(2, RSIPeriod + MAPeriod + 1);

   return(0);
}

int start()
{
   int toCount = Bars - IndicatorCounted();  
   
   // count values
   for (int i = toCount - 1; i >=0; i--)
   {
      Values[i] = NormalizeDouble(iRSI(Symbol(), 0, RSIPeriod, AppliedPrice, i), DigitsUsed);
   }
      
   // count smoothed values
   for (i = toCount - 1; i >=0; i--)
   {
      SmoothedValues[i] = NormalizeDouble(iMAOnArray(Values, 0, MAPeriod, 0, MODE_EMA, i), DigitsUsed);
   }
      
   // mark crosses
   for (i = toCount - 1; i >=0; i--)
   {
      // to check we need at least 1 older bars
      // if they are not available, there is no reason to continue
      if (i + 1 >= Bars)
      {
         continue;
      }

      // check empty values
      if (
            Values[i]               == EmptyValueUsed || 
            Values[i + 1]           == EmptyValueUsed ||
            SmoothedValues[i]       == EmptyValueUsed || 
            SmoothedValues[i + 1]   == EmptyValueUsed ||
            Values[i]               == EMPTY_VALUE    || 
            Values[i + 1]           == EMPTY_VALUE    ||
            SmoothedValues[i]       == EMPTY_VALUE    || 
            SmoothedValues[i + 1]   == EMPTY_VALUE
      )
      {
         continue;
      }
      
      // clean current mark
      Crosses[i] = EMPTY_VALUE;
      
      // cross check (simple case)
      if ((Values[i] - SmoothedValues[i])*(Values[i + 1] - SmoothedValues[i + 1]) < 0)
      {
         Crosses[i] = SmoothedValues[i];
         continue;
      }
      
      // cross check (complicated case)
      if (Values[i + 1] == SmoothedValues[i + 1] && Values[i] != SmoothedValues[i])
      {
         // we have potential cross

         int index = i + 1;
         bool found = false;
         while (
               index < Bars && 
               Values[index] != EmptyValueUsed && 
               Values[index] != EMPTY_VALUE &&
               SmoothedValues[index] != EmptyValueUsed && 
               SmoothedValues[index] != EMPTY_VALUE)
         {
            if (Values[index] != SmoothedValues[index])
            {
               // got the end
               found = true;
               break;
            }
            
            index++;
         }

         if (!found)
         {
            // not got the end
            continue;
         }
         
         // test the cross
         if ((Values[i] - SmoothedValues[i])*(Values[index] - SmoothedValues[index]) < 0)
         {
            // got it
            Crosses[i] = SmoothedValues[i];
         }  // got touching
      }
   }
   
   return(0);
}