//+------------------------------------------------------------------+
//|                                              2MA_Lib_Sample2.mq4 |
//|                                       Copyright  2009, TheXpert |
//|                                           theforexpert@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, TheXpert"
#property link      "theforexpert@gmail.com"

#include <Indicator_Painting.mqh>

#property indicator_chart_window

#property indicator_buffers 7

#property indicator_color1 Yellow
#property indicator_color2 Gray
#property indicator_color3 Gray
#property indicator_color4 DeepSkyBlue
#property indicator_color5 Red
#property indicator_color6 Red
#property indicator_color7 DeepSkyBlue
#property indicator_color8 White

#property indicator_width1 3
#property indicator_width2 3
#property indicator_width3 3
#property indicator_width4 3
#property indicator_width5 3
#property indicator_width6 3
#property indicator_width7 3
#property indicator_width8 3

extern int SlowPeriod      = 40;
extern int FastPeriod      = 15;

// buffers
double FastValues[];       
double SlowHiValues[];     
double SlowLoValues[];     
double FastHiLevels[];
double FastLoLevels[];
double FastTops[];         
double FastBottoms[];      

int DigitsUsed = 6;
int EmptyValueUsed = 0;

int init()
{
   SetIndexBuffer(0, FastValues);
   SetIndexBuffer(1, SlowHiValues);
   SetIndexBuffer(2, SlowLoValues);
   
   SetIndexBuffer(3, FastHiLevels);
   SetIndexBuffer(4, FastLoLevels);
   
   SetIndexBuffer(5, FastTops);
   SetIndexBuffer(6, FastBottoms);

   // buffer settings
   SetIndexStyle(0, DRAW_LINE);
   SetIndexStyle(1, DRAW_LINE);
   SetIndexStyle(2, DRAW_LINE);
   SetIndexStyle(3, DRAW_LINE);
   SetIndexStyle(4, DRAW_LINE);
   SetIndexStyle(5, DRAW_ARROW, STYLE_SOLID, 3);
   SetIndexStyle(6, DRAW_ARROW, STYLE_SOLID, 3);
   
   SetIndexArrow(5, 159);
   SetIndexArrow(6, 159);

   return(0);
}

int start()
{
   int toCount = Bars - IndicatorCounted();  
   
   // count values
   for (int i = toCount - 1; i >=0; i--)
   {
      FastValues[i] = NormalizeDouble(iMA(Symbol(), 0, FastPeriod, 0, MODE_EMA, PRICE_CLOSE, i), DigitsUsed);
      SlowHiValues[i] = NormalizeDouble(iMA(Symbol(), 0, SlowPeriod, 0, MODE_EMA, PRICE_HIGH, i), DigitsUsed);
      SlowLoValues[i] = NormalizeDouble(iMA(Symbol(), 0, SlowPeriod, 0, MODE_EMA, PRICE_LOW, i), DigitsUsed);
   }
      
   MarkDynamicLevel(FastValues, SlowHiValues, FastHiLevels, toCount - 1, 0, GREATER_THAN, EmptyValueUsed);
   MarkDynamicLevel(FastValues, SlowLoValues, FastLoLevels, toCount - 1, 0, LESS_THAN, EmptyValueUsed);
   
   MarkExtremums(FastValues, FastTops, toCount - 1, 0, DIR_TOP, EmptyValueUsed);
   MarkExtremums(FastValues, FastBottoms, toCount - 1, 0, DIR_BOTTOM, EmptyValueUsed);

   return(0);
}