//+------------------------------------------------------------------+
//|                                         RSI_Extremums_Sample.mq4 |
//|                                       Copyright  2009, TheXpert |
//|                                           theforexpert@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, TheXpert"
#property link      "theforexpert@gmail.com"

#property indicator_separate_window

#property indicator_buffers 2

#property indicator_minimum 0
#property indicator_maximum 100

#property indicator_color1  White
#property indicator_color2  Red

extern int RSIPeriod       = 9;
extern int AppliedPrice    = 0;

// buffers
double Values[];           // values
double Extremums[];        // extremums

int DigitsUsed = 5;
int EmptyValueUsed = 0;

int init()
{
   SetIndexBuffer(0, Values);
   SetIndexBuffer(1, Extremums);
   
   // buffers settings
   SetIndexStyle(0, DRAW_LINE);     // values are drawn as a solid line

   SetIndexStyle(1, DRAW_ARROW, STYLE_SOLID, 3);    // extremums are drawn as circles
   SetIndexArrow(1, 159);
   
   IndicatorDigits(DigitsUsed);
   
   SetIndexDrawBegin(0, RSIPeriod);
   SetIndexDrawBegin(1, RSIPeriod + 2);

   return(0);
}

int start()
{
   int toCount = Bars - IndicatorCounted();  
   for (int i = toCount - 1; i >=0; i--)
   {
      Values[i] = NormalizeDouble(iRSI(Symbol(), 0, RSIPeriod, AppliedPrice, i), DigitsUsed);
   }
      
   for (i = toCount - 1; i >=0; i--)
   {
      // to check the extremum we need at least 2 older bars
      // if they are not available, there is no reason to continue
      if (i + 2 >= Bars)
      {
         continue;
      }

      // check empty values
      if (
            Values[i]      == EmptyValueUsed || 
            Values[i + 1]  == EmptyValueUsed ||
            Values[i + 2]  == EmptyValueUsed
      )
      {
         continue;
      }
      
      // clean current mark
      Extremums[i + 1] = EMPTY_VALUE;
      
      // extremum condition -- simple case
      if ((Values[i] - Values[i + 1])*(Values[i + 1] - Values[i + 2]) < 0)
      {
         // if available
         Extremums[i + 1] = Values[i + 1];
         continue;
      }
      
      // extremum condition -- complicated case
      if (Values[i + 1] == Values[i + 2] && Values[i] != Values[i + 1])
      {
         // potential one is available

         int index = i + 2;
         bool found = false;
         while (index < Bars && Values[index] != EmptyValueUsed && Values[index] != EMPTY_VALUE)
         {
            if (Values[i + 2] != Values[index])
            {
               // got the end
               found = true;
               break;
            }
            
            index++;
         }

         if (!found)
         {
            // not got the end
            continue;
         }
         
         // test the extremum
         if ((Values[i] - Values[i + 1])*(Values[i + 1] - Values[index]) < 0)
         {
            // got it
            Extremums[i + 1] = Values[i + 1];
         }  // got bending
      }
   }
   
   return(0);
}++;
         }

         if (!found)
         {
            //     ,     
            //       
            continue;
         }
         
         //    
         if ((Values[i] - Values[i + 1])*(Values[i + 1] - Values[index]) < 0)
         {
            //  
            Extremums[i + 1] = Values[i + 1];
         }  // else --    ,   
      }
   }
   
   return(0);
}