//+------------------------------------------------------------------+
//|                                                    testClose.mq5 |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                                 denkir@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2010, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
//---
   Print("Number of bars on the symbol-periods = ",
         SeriesInfoInteger(Symbol(),0,SERIES_BARS_COUNT));
   Print("The very first date = ",
         (datetime)SeriesInfoInteger(Symbol(),0,SERIES_FIRSTDATE));

   Print("The very first date on the server = ",
         (datetime)SeriesInfoInteger(Symbol(),0,SERIES_SERVER_FIRSTDATE));

   Print("The historical data is synchronized = ",
         (bool)SeriesInfoInteger(Symbol(),0,SERIES_SYNCHRONIZED));

   long n1=SeriesInfoInteger(Symbol(),0,SERIES_BARS_COUNT);

   MqlRates rates[];
   ArraySetAsSeries(rates,true);
//int ss = ArraySize(arr);
   double nOpen[],nHigh[],nLow[],nClose[];
   int nSpread[];
   datetime nTime[];

   ArrayResize(nOpen,n1);
   ArrayResize(nHigh,n1);
   ArrayResize(nLow,n1);
   ArrayResize(nClose,n1);
   ArrayResize(nSpread,n1);
   ArrayResize(nTime,n1);

   int copied=CopyRates(Symbol(),0,0,n1,rates);
   if(copied>0)
      Print("Bars copied: "+copied);
   else
      Print("Failed to get the historical price data on symbol",Symbol());
   for(int i=0;i<n1;i++)
     {
      nOpen[i] = rates[i].open;
      nHigh[i] = rates[i].high;
      nLow[i]=rates[i].low;
      nClose[i]=rates[i].close;
      nSpread[i]=rates[i].spread;
      nTime[i]=rates[i].time;
     }
   ArraySetAsSeries(nOpen,true);
   ArraySetAsSeries(nHigh,true);
   ArraySetAsSeries(nLow,true);
   ArraySetAsSeries(nClose,true);
   ArraySetAsSeries(nSpread,true);
   ArraySetAsSeries(nTime,true);
//--- the correct way to work with the "File Sandbox"
   int filehandle=FileOpen("Price.txt",FILE_TXT|FILE_WRITE|FILE_ANSI);//|FILE_UNICODE);
   if(filehandle!=INVALID_HANDLE)
     {
      for(int i=0;i<n1;i++)
        {
         string Str1;
         StringConcatenate(Str1,DoubleToString(nOpen[i],5)," \t");
         FileWriteString(filehandle,Str1);
         string Str2;
         StringConcatenate(Str2,DoubleToString(nHigh[i],5)," \t");
         FileWriteString(filehandle,Str2);
         string Str3;
         StringConcatenate(Str3,DoubleToString(nLow[i],5)," \t");
         FileWriteString(filehandle,Str3);
         string Str4;
         StringConcatenate(Str4,DoubleToString(nClose[i],5)," \t");
         FileWriteString(filehandle,Str4);
         string Str5;
         StringConcatenate(Str5,IntegerToString(nSpread[i])," \t");
         FileWriteString(filehandle,Str5);
         string Str6;
         StringConcatenate(Str6,TimeToString(nTime[i])," \n");
         FileWriteString(filehandle,Str6);
        }
      FileClose(filehandle);
      Print("FileOpen OK");
     }
   else Print("FileOpen failed, error=",GetLastError());

  }
//+------------------------------------------------------------------+