//+------------------------------------------------------------------+
//|                                                          mts.mq5 |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2010, MetaQuotes Software Corp."
#property link      "denkir@gmail.com"
#property version   "1.00"
//--- input parameters
input int      K=3;                // bar to open position after the crossing of 21/55:
                                   // "K" and "K-Delay" data in "Position handling"
input int      TakeProfit = 295;   // Take Profit: "Take Profit" in FromWorkspace
input int      StopLoss = 65;      // Stop Loss: "Stop Loss" in FromWorkspace
input int      MA1_Period = 21;    // Moving Average1 period
input int      MA2_Period= 55;     // Moving Average2 period
input int      Magic=76767;        // Magic Number of Expert Advisor

//--- global variables
double   Lot=1; // Number of lots to trade: "Lots" in Position handling
int ma1Handle;  // Moving Average 1 indicator handle: "ema21 signal" 
int ma2Handle;  // Moving Average 2 indicator handle: "ema55 signal"

double ma1Val[]; // Dynamic array to hold the values of Moving Average 1 for each bar: "ema21 signal"
double ma2Val[]; // Dynamic array to hold the values of Moving Average 2 for each bar: "ema55 signal"

int sl,tp;       // will be used for the Stop Loss and Take Profit
//+------------------------------------------------------------------+
//| Checking for opened position                                     |
//+------------------------------------------------------------------+
bool IsTraded(bool IsBought,bool IsSold)
  {
   if(IsSold || IsBought)
     {
      Alert("The deal has performed.");
      return(true);
     }
   else
      return(false);
  }
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- minimal number of bars
   if(Bars(_Symbol,_Period)<56) // 1st period of "Position handlin": [Input.num>=56] condition
     {
      Alert("Insufficient bars!");
      return(-1);
     }
//get handle of Moving Average 1 indicator: "ema21 signal"
   ma1Handle=iMA(_Symbol,_Period,MA1_Period,0,MODE_EMA,PRICE_CLOSE);
//get handle of Moving Average 2 indicator: "ema55 signal"
   ma2Handle=iMA(_Symbol,_Period,MA2_Period,0,MODE_EMA,PRICE_CLOSE);
//--- checking handles
   if(ma1Handle<0 || ma2Handle<0)
     {
      Alert("Error in creating the indicators - error: ",GetLastError(),"!!");
      return(-1);
     }
//--- For work with brokers with 5-digit quotes
//--- we multiply SL and TP by 10
   sl = StopLoss;
   tp = TakeProfit;
   if(_Digits==5)
     {
      sl = sl*10;
      tp = tp*10;
     }

   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//--- Release the handles
   IndicatorRelease(ma1Handle);
   IndicatorRelease(ma2Handle);
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {

//checking for a new bar
   static datetime Old_Time;

   datetime New_Time[1];
   bool IsNewBar=false;
   int copied=CopyTime(_Symbol,_Period,0,1,New_Time);
   if(copied>0)
     {
      if(Old_Time!=New_Time[0])
        {
         IsNewBar=true;
         Old_Time=New_Time[0];
        }
     }
   else
     {
      Alert("Error =",GetLastError());
      ResetLastError();
      return;
     }
   if(IsNewBar==false)
     {
      return;
     }

//--- Declare the structures, used in trade
   MqlTick latest_price;       // Will be used for current Quotes
   MqlTradeRequest mrequest;   // Will be used for trade requests
   MqlTradeResult mresult;     // Will be used for trade results
   MqlRates mrate[];           // Will serve the prices, volumes and spread for each bar
   ZeroMemory(mrequest);
/*
     Set indexation as timeseries
*/
   ArraySetAsSeries(mrate,true); // Rates
   ArraySetAsSeries(ma1Val,true);// values of MA1: "ema21 signal"
   ArraySetAsSeries(ma2Val,true);// values of MA2: "ema55 signal"

//--- get current quotes to the structure of MqlTick type
   if(!SymbolInfoTick(_Symbol,latest_price))
     {
      Alert("Error in getting the last prices - error:",GetLastError(),"!!");
      return;
     }

//--- get historical price data for the recent 2+K bars
   if(CopyRates(_Symbol,_Period,0,2+K,mrate)<0)
     {
      Alert("Error in copying historical price data - error:",GetLastError(),"!!");
      return;
     }

//--- Copy the new values of our indicators to buffers (arrays) using the handle
   if(CopyBuffer(ma1Handle,0,0,2+K,ma1Val)<0)
     {
      Alert("Error in copying the value of the Moving Average 1 indicator - error:",GetLastError());
      return;
     }
   if(CopyBuffer(ma2Handle,0,0,2+K,ma2Val)<0)
     {
      Alert("Error in copying the value of the Moving Average 2 indicator - error:",GetLastError());
      return;
     }
//--- 1-st transition of "Position handling" subsystem: [Input.num>Output.barClose] condition
   bool IsBought=false;  // bought
   bool IsSold=false;    // sold

   if(PositionSelect(_Symbol)==true)
     {
      if(PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_BUY)
        {
         IsBought=true;  //long
        }
      else if(PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_SELL)
        {
         IsSold=true;    // short
        }
     }

/*
    Checking conditions for buy : 
    at (1+K)th bar the EMA 21<EMA 55
    at Kth bar the EMA 21>EMA 55   
*/
/* check conditions for buy: "emas differential"; 
   K bars lag: "K Delay"    
   creating Buy event
*/
//creating OpenBuy event: "Position opening" subsystem
   bool Buy=((ma2Val[1+K]-ma1Val[1+K])>=0 && (ma2Val[K]-ma1Val[K])<0) || ((ma2Val[1+K]-ma1Val[1+K])>0 && (ma2Val[K]-ma1Val[K])==0);
//OpenBuy: "Position handling", its conditions and functions
   if(Buy)
     {
      if(IsTraded(IsBought,IsSold))
        {
         return;
        } 
     
      //4th transition of "Position handling": opening of the long position
      mrequest.action = TRADE_ACTION_DEAL;                                  // Market buy
      mrequest.price = NormalizeDouble(latest_price.ask,_Digits);           // Last ask price
      mrequest.sl = NormalizeDouble(latest_price.bid - sl*_Point,_Digits);  // Stop Loss
      mrequest.tp = NormalizeDouble(latest_price.bid + tp*_Point,_Digits);  // Take Profit
      mrequest.symbol = _Symbol;                                            // Symbol
      mrequest.volume = Lot;                                                // Lots to trade
      mrequest.magic=Magic;                                                 // Magic Number
      mrequest.type = ORDER_TYPE_BUY;                                       // Buy order
      mrequest.type_filling = ORDER_FILLING_FOK;                            // Fill or Kill
      mrequest.deviation=100;                                               // Slippage
      OrderSend(mrequest,mresult);
      if(mresult.retcode==10009 || mresult.retcode==10008) // request executed or order placed
        {
         //Open_Time=New_Time[0];
         Alert("A buy order has been placed, ticket #:",mresult.order);
        }
      else
        {
         Alert("A sell order hasn't been placed; error:",GetLastError());
         return;
        }
     }
/*
    Checking conditions for sell:
     At (1+K)th bar: EMA 21>EMA 55
     At Kth bar: EMA 21<EMA 55
*/

/* check conditions for sell: "emas differential"; 
   K bars lag: "K Delay"    
   creating Sell event
*/   
//Create OpenSell event: "Position opening" subsystem
   bool Sell=((ma2Val[1+K]-ma1Val[1+K])<=0 && (ma2Val[K]-ma1Val[K])>0) || ((ma2Val[1+K]-ma1Val[1+K])<0 && (ma2Val[K]-ma1Val[K])==0);

//OpenSell event processing: "Position handling", its conditions and functions
   if(Sell)
     {
      if(IsTraded(IsBought,IsSold))
        {
         return;
        } 
      // the 5th transition of Position handling: open short position
      mrequest.action = TRADE_ACTION_DEAL;                                  // Market sell
      mrequest.price = NormalizeDouble(latest_price.bid,_Digits);           // Last bid price
      mrequest.sl=NormalizeDouble(latest_price.ask+sl*_Point,_Digits);      // Stop Loss
      mrequest.tp=NormalizeDouble(latest_price.ask-tp*_Point,_Digits);      // Take Profit
      mrequest.symbol = _Symbol;                                            // Symbol
      mrequest.volume = Lot;                                                // Number of lots
      mrequest.magic=Magic;                                                 // Magic Number
      mrequest.type= ORDER_TYPE_SELL;                                       // Sell order
      mrequest.type_filling = ORDER_FILLING_FOK;                            // Fill or Kill
      mrequest.deviation=100;                                               // slippage
      OrderSend(mrequest,mresult);
      if(mresult.retcode==10009 || mresult.retcode==10008) // request executed or order placed
        {
         Alert("A sell order has been placed, ticket #:",mresult.order);
        }
      else
        {
         //Open_Time=New_Time[0];
         Alert("A sell order hasn't been placed; Error:",GetLastError());
         return;
        }
     }
   return;

//+------------------------------------------------------------------+
  }
//+------------------------------------------------------------------+
