//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "VarChangeFormUnit.h"
#include "MainFormUnit.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TVarChangeForm *VarChangeForm;
//---------------------------------------------------------------------------
__fastcall TVarChangeForm::TVarChangeForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TVarChangeForm::Button2Click(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------
void __fastcall TVarChangeForm::FormShow(TObject *Sender)
{
	Label2->Caption=MainForm->Var[VarIndex].Title;

	if (MainForm->Var[VarIndex].Type==1)
		Label4->Caption="String";
	else if (MainForm->Var[VarIndex].Type==2)
		Label4->Caption="Integer";
	else if (MainForm->Var[VarIndex].Type==3)
		Label4->Caption="Double";
	else if (MainForm->Var[VarIndex].Type==4)
		Label4->Caption="Date";

	Edit1->Text=MainForm->Var[VarIndex].Value;
	Edit1->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TVarChangeForm::Button1Click(TObject *Sender)
{
	bool ChangeFlag=true;

	// integer
	if (MainForm->Var[VarIndex].Type==2)
	{
		try
		{
			Edit1->Text.ToInt();
		} catch(...)
		{
			ChangeFlag=false;
			Application->MessageBoxA("Variable value is incorrect","Warning",MB_OK);
		}
	}
	// double
	else if (MainForm->Var[VarIndex].Type==3)
	{
		try
		{
			Edit1->Text.ToDouble();
		} catch(...)
		{
			ChangeFlag=false;
			Application->MessageBoxA("Variable value is incorrect","Warning",MB_OK);
		}
	}
	// date
	else if (MainForm->Var[VarIndex].Type==4)
	{
		try
		{
			StrToDate(Edit1->Text);
		} catch(...)
		{
			ChangeFlag=false;
			Application->MessageBoxA("Variable value is incorrect","Warning",MB_OK);
		}
	}
	if (ChangeFlag)
	{
		if ((MainForm->Var[VarIndex].Value)!=(Edit1->Text))
		{
			MainForm->Var[VarIndex].Value=Edit1->Text;
			if (MainForm->Var[VarIndex].Status!=2)
				MainForm->Var[VarIndex].Status=1;
			MainForm->SaveVarList();
			MainForm->ForceVarRedraw();
			Close();
		} else
		{
			Application->MessageBoxA("Value is the same","Warning",MB_OK);
		}
	}
}
//---------------------------------------------------------------------------
