//---------------------------------------------------------------------------
#ifndef MainFormUnitH
#define MainFormUnitH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Menus.hpp>
#include <Dialogs.hpp>
#include <Grids.hpp>
#include <ExtCtrls.hpp>
//---------------------------------------------------------------------------
struct TVar
{
	AnsiString Title;
	int Type; // 0 - string; 1 - int; 2 - double; 3 - date; 4 - boolean 5 - action
	int Status; // 0 - idle; 1 - changed by ExVH; 2 - accepted by MT
	AnsiString Value;
};

class TMainForm : public TForm
{
__published:	// IDE-managed Components
	TMainMenu *MainMenu1;
	TMenuItem *Help1;
	TMenuItem *About1;
	TOpenDialog *OpenDialog1;
	TStringGrid *StringGrid1;
	TMenuItem *P1;
	TMenuItem *Open1;
	TMenuItem *Close1;
	TTimer *Timer1;
	TBevel *Bevel1;
	void __fastcall About1Click(TObject *Sender);
	void __fastcall FormShow(TObject *Sender);
	void __fastcall Open1Click(TObject *Sender);
	void __fastcall Close1Click(TObject *Sender);
	void __fastcall Timer1Timer(TObject *Sender);
	void __fastcall StringGrid1DblClick(TObject *Sender);
private:	// User declarations
public:		// User declarations
	__fastcall TMainForm(TComponent* Owner);
	void LoadConfig();
	void SaveConfig();
	bool CheckForProject(AnsiString FN);
	void ClearStringGrid();
	void LoadProject();
	void CloseProject();
    void LoadVarList();
	void SaveVarList();
	void FillVarList();
	void ForceVarRedraw();

	AnsiString AppPath;
	AnsiString MTPath;
	AnsiString Project;

	bool ProjectLoaded;

	bool SaveMode;

	int VarCnt;
	TVar Var[256];
};
//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
//---------------------------------------------------------------------------
#endif
