//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "IniFiles.hpp"
#include "MainFormUnit.h"
#include "AboutFormUnit.h"
#include "VarChangeFormUnit.h"
                   
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
	: TForm(Owner)
{
	AppPath=ExtractFilePath(Application->ExeName);
	SaveMode=false;
	ProjectLoaded=false;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::About1Click(TObject *Sender)
{
	AboutForm->ShowModal();
}
//---------------------------------------------------------------------------
void TMainForm::LoadConfig()
{
	TIniFile *IniFile;
	IniFile=new TIniFile(AppPath+"\\exvh.ini");
	MTPath=IniFile->ReadString("ExVH","MTPath","");
	Project=IniFile->ReadString("ExVH","Project","");
	delete IniFile;
}

void TMainForm::SaveConfig()
{
	TIniFile *IniFile;
	IniFile=new TIniFile(AppPath+"\\exvh.ini");
	IniFile->WriteString("ExVH","MTPath",MTPath);
	IniFile->WriteString("ExVH","Project",Project);
	delete IniFile;
}
void __fastcall TMainForm::FormShow(TObject *Sender)
{
	DecimalSeparator='.';
	ClearStringGrid();
	MainForm->Caption="ExVH";
	Project="";
	LoadConfig();
	if (Project!="")
	{
		if (CheckForProject(Project))
		{
			ProjectLoaded=true;
			MainForm->Caption="ExVH - "+ExtractFileName(Project);
			LoadProject();
		} else
		{
			AnsiString Str="Associated project file "+ExtractFileName(Project)+" is not found.";
			Application->MessageBoxA(Str.c_str(),"Warning",MB_OK);
		}
	}
}
//---------------------------------------------------------------------------
bool TMainForm::CheckForProject(AnsiString FN)
{
	TIniFile *IniFile;
	IniFile=new TIniFile(FN);
	AnsiString Signature=IniFile->ReadString("EXVH 1.0","Var_Cnt","false");
	delete IniFile;
	if (Signature!="false")
		return(true);
	else
		return(false);
}

void TMainForm::LoadProject()
{
	ClearStringGrid();
	LoadVarList();
	FillVarList();
}

void TMainForm::CloseProject()
{
	ClearStringGrid();
	MainForm->Caption="ExVH";
	ProjectLoaded=false;
	Project="";
	SaveConfig();
}

void TMainForm::ClearStringGrid()
{
	StringGrid1->ColCount=4;
	StringGrid1->RowCount=2;

	StringGrid1->Cells[0][0]="Variable";
	StringGrid1->Cells[1][0]="Type";
	StringGrid1->Cells[2][0]="Status";
	StringGrid1->Cells[3][0]="Value";

	StringGrid1->Cells[0][1]="";
	StringGrid1->Cells[1][1]="";
	StringGrid1->Cells[2][1]="";
	StringGrid1->Cells[3][1]="";
}

void __fastcall TMainForm::Open1Click(TObject *Sender)
{
	OpenDialog1->InitialDir=MTPath+"\\experts\\files\\";
	if (OpenDialog1->Execute())
	{
		if (CheckForProject(OpenDialog1->FileName))
		{
			Project=OpenDialog1->FileName;
			SaveConfig();
			ProjectLoaded=true;
			MainForm->Caption="ExVH - "+ExtractFileName(Project);
		} else
		{
			Application->MessageBoxA("Project file is not correct","Warning",MB_OK|MB_ICONEXCLAMATION);
		}
	}	
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Close1Click(TObject *Sender)
{
	if (ProjectLoaded)
	{
		if (Application->MessageBoxA("Do you want to close project?","Warning",MB_YESNO)==ID_YES)
			CloseProject();
	} else
		CloseProject();
}
//---------------------------------------------------------------------------
void TMainForm::SaveVarList()
{
	SaveMode=true;
	TIniFile *IniFile;
	IniFile=new TIniFile(Project);
	IniFile->WriteInteger("ExVH 1.0","Var_Cnt",VarCnt);
	for (int i = 1; i <= VarCnt; i++)
	{
		IniFile->WriteString("ExVH 1.0","Var"+IntToStr(i)+"_Title",Var[i-1].Title);
		IniFile->WriteInteger("ExVH 1.0","Var"+IntToStr(i)+"_Type",Var[i-1].Type);
		IniFile->WriteInteger("ExVH 1.0","Var"+IntToStr(i)+"_Status",Var[i-1].Status);
		IniFile->WriteString("ExVH 1.0","Var"+IntToStr(i)+"_Value",Var[i-1].Value);
	}
	delete IniFile;
	SaveMode=false;
}

void TMainForm::LoadVarList()
{
	TIniFile *IniFile;
	IniFile=new TIniFile(Project);
	VarCnt=IniFile->ReadInteger("ExVH 1.0","Var_Cnt",0);
	for (int i = 1; i <= VarCnt; i++)
	{
		AnsiString Str="Var"+IntToStr(i)+"_Title";
		Var[i-1].Title=IniFile->ReadString("ExVH 1.0",Str,"");
		Str="Var"+IntToStr(i)+"_Type";
		Var[i-1].Type=IniFile->ReadInteger("ExVH 1.0",Str,0);
		Str="Var"+IntToStr(i)+"_Status";
		Var[i-1].Status=IniFile->ReadInteger("ExVH 1.0",Str,0);
		Str="Var"+IntToStr(i)+"_Value";
		Var[i-1].Value=IniFile->ReadString("ExVH 1.0",Str,"");
	}
	delete IniFile;
}

void TMainForm::FillVarList()
{
	StringGrid1->RowCount=VarCnt+1;
	for (int i = 0; i < VarCnt; i++)
	{
		StringGrid1->Cells[0][i+1]=Var[i].Title;

		if (Var[i].Type==0)
			StringGrid1->Cells[1][i+1]="boolean";
		else if (Var[i].Type==1)
			StringGrid1->Cells[1][i+1]="string";
		else if (Var[i].Type==2)
			StringGrid1->Cells[1][i+1]="integer";
		else if (Var[i].Type==3)
			StringGrid1->Cells[1][i+1]="double";
		else if (Var[i].Type==4)
			StringGrid1->Cells[1][i+1]="date";
		else if (Var[i].Type==5)
			StringGrid1->Cells[1][i+1]="action";

		if (Var[i].Status==0)
			StringGrid1->Cells[2][i+1]="idle";
		else if (Var[i].Status==1)
			StringGrid1->Cells[2][i+1]="changed by ExVH";
		else if (Var[i].Status==2)
			StringGrid1->Cells[2][i+1]="idle";

		if (Var[i].Type==0) // boolean
		{
			if (Var[i].Value=="1")
				StringGrid1->Cells[3][i+1]="true";
			else
				StringGrid1->Cells[3][i+1]="false";
		} else if (Var[i].Type==5) // action
		{
			StringGrid1->Cells[3][i+1]="";
		}
		else // other var types
			StringGrid1->Cells[3][i+1]=Var[i].Value;
	}
}

void __fastcall TMainForm::Timer1Timer(TObject *Sender)
{
	if (ProjectLoaded)
		if (!SaveMode)
		{
			LoadVarList();
			if (VarCnt>0)
				FillVarList();
		}

}
//---------------------------------------------------------------------------
void TMainForm::ForceVarRedraw()
{
	Timer1Timer(NULL);
}

void __fastcall TMainForm::StringGrid1DblClick(TObject *Sender)
{
	if (VarCnt>0)
	{
		// Action
		if (Var[StringGrid1->Row-1].Type==5)
		{
			if (Var[StringGrid1->Row-1].Status==0)
			{
				if (Application->MessageBoxA("Do you want to activate this action?","Warning",MB_YESNO)==ID_YES)
				{
					Var[StringGrid1->Row-1].Status=1;
					SaveVarList();
					ForceVarRedraw();
				}
			} else
			{
				if (Application->MessageBoxA("Do you want to cancel action activation?","Warning",MB_YESNO)==ID_YES)
				{
					Var[StringGrid1->Row-1].Status=0;
					SaveVarList();
					ForceVarRedraw();
				}
			}
		}
		// boolean
		else if (Var[StringGrid1->Row-1].Type==0)
		{
			if (Var[StringGrid1->Row-1].Value=="0")
			{
				if (Application->MessageBoxA("Do you want to change FALSE to TRUE?","Warning",MB_YESNO)==ID_YES)
				{
					if (Var[StringGrid1->Row-1].Status!=2)
						Var[StringGrid1->Row-1].Status=1;
					Var[StringGrid1->Row-1].Value="1";
					SaveVarList();
					ForceVarRedraw();
				}

			} else if (Var[StringGrid1->Row-1].Value=="1")
			{
				if (Application->MessageBoxA("Do you want to change TRUE to FALSE?","Warning",MB_YESNO)==ID_YES)
				{
					if (Var[StringGrid1->Row-1].Status!=2)
						Var[StringGrid1->Row-1].Status=1;
					Var[StringGrid1->Row-1].Value="0";
					SaveVarList();
					ForceVarRedraw();
				}
			}
		} else
		{
			VarChangeForm->VarIndex=StringGrid1->Row-1;
			VarChangeForm->ShowModal();
		}
	}

}
//---------------------------------------------------------------------------

