//+------------------------------------------------------------------+
//|                                                    sequences.mq4 |
//|                                                Mathemat (c) 2008 |
//+------------------------------------------------------------------+
/*
     ,  
  ,    (
 ),       
 .
*/

#property copyright "Mathemat (c) 2008"
#property show_inputs

extern int    _what = 1; // 1 -  , -1 - 
extern string _fname = "3_20_10_mono_Home.htm";    //   
extern int _globalSeriesQty = 1000;    //     ()

int _colsInHisto;
int _res[]; // ,     
int _seq[]; //      
int _histogramReal[]; //      
                       //   (    )

int _resSynth[]; // ,     
int _seqSynth[]; //        
int _histogramSynth[];  //     - 
                        //      

int _1[], _2[], _3[], _4[], _5[], _6[], _7[], _8[], _9[], _10[]; //  
                        //      
                        //    

extern int    _testsTotal = 0;  //    ()    
extern double _probab = 0;  //  ,   _what


bool _first = true;
int _type = 0; // 0 -  , 1 - 
double _meanDevAbs = 0;
double _meanDev = 0;
int _outliers = 0;
int _nrOfHistograms = 0;    //    (  )

//+------------------------------------------------------------------+


int mathSign(  double var )
{
   int res = 1;
   if( var < 0 ) res = -1;
   return( res );
}//+------------------------------------------------------------------+


//        (   )
void findSubString( int& fh, string ss )
{
  string s;
  while ( !FileIsEnding( fh ) )
  {
    s = FileReadString( fh );
    if( StringFind( s, ss ) >= 0 )  break;
  }
  return;
}


//        1  -1.    
//  </td><td class=mspt>- ,  1.  ,  -1.
double extractResult( string str )
{
   int minusFound = StringFind( str, "</td><td class=mspt>-" );
   return( -mathSign( minusFound ) );
}//+------------------------------------------------------------------+



//         "Balance",    
//     
void readIntoArray()
{
   int h = FileOpen( "Sequences\\" + _fname, FILE_CSV | FILE_READ, "," );
   findSubString( h, "Balance" );
   
   int size = 0;                 //     
   string s;                     // ,      
   double res;                   //   (+-1)     
   int iStrFound;                //    close, t/p, s/l  
   while( !FileIsEnding( h ) )
   {
      s = FileReadString( h );
      iStrFound = StringFind( s, "</td><td>close</td><td>" ) +
                  StringFind( s, "</td><td>t/p</td><td>" ) +
                  StringFind( s, "</td><td>s/l</td><td>" ) +
                  StringFind( s, "</td><td>close at stop</td><td>" );
      if( iStrFound > -4 )     //       
      {
         res = extractResult( s );
         size ++;
         ArrayResize( _res, size ); 
         _res[ size - 1 ] = res;
      }
   }
   FileClose( h );
   return;
}//+------------------------------------------------------------------+


//         
void writeArrayToFile( int arr[], int& h, string comment )
{
   string res = comment + ",";
   int size = ArraySize( arr );
   for( int i = 0; i < size; i ++ )   res = res + DoubleToStr( arr[ i ], 0 ) + ",";
   FileWrite( h, res );
}//+------------------------------------------------------------------+




//      ,      _what
void formClustersArray( int results[], int& sequences[], int& h, int nr )
{
   int deals = 0;    //  ,   _what
   int seqArrSize = 0;
   int size = ArraySize( results );
      
   //      ( )
   int count = 1;
   
   int sign = 1;  
   if( results[ 0 ] < 0 )     sign = -1;
   
   for( int i = 1; i < size; i ++ )
   {
      if( results[ i ] == sign )  
         count ++;   //   ,    ( )
      else           //  ,  
      {
         if( sign == _what )
         {
            seqArrSize ++;
            ArrayResize( sequences, seqArrSize ); //    
            sequences[ seqArrSize - 1 ] = count;  //    
            deals += count;
         }   
         sign = -sign;                    //   
         count = 1;                       //     
      }
   }

   if( _first )     //     -  
   {
      _first = false;
      //      ,    
      if( _testsTotal == 0 )    _testsTotal = size;
      //  , . _what
      if( _probab < 0.001 )      _probab = ( deals + 0. ) / size;    
      
   }   
   return;
}//+------------------------------------------------------------------+


//     seq[],  len (len-)
int getQuantityHistogr( int seq[], int len )
{
   int size = ArraySize( seq );
   int count = 0;
   for( int i = 0; i < size; i ++ )
      if( seq[ i ] == len )  count ++;
   return( count );   
}//+------------------------------------------------------------------+


//   .    
int getLongest( int seq[] )
{
   return( seq[ ArrayMaximum( seq ) ] );
}//+------------------------------------------------------------------+


void allArraysPrepare()
{
   ArrayResize( _1, _globalSeriesQty );
   ArrayResize( _2, _globalSeriesQty );
   ArrayResize( _3, _globalSeriesQty );
   ArrayResize( _4, _globalSeriesQty );
   ArrayResize( _5, _globalSeriesQty );
   ArrayResize( _6, _globalSeriesQty );
   ArrayResize( _7, _globalSeriesQty );
   ArrayResize( _8, _globalSeriesQty );
   ArrayResize( _9, _globalSeriesQty );
   ArrayResize( _10, _globalSeriesQty );
   
   ArrayInitialize( _1, 0 );
   ArrayInitialize( _2, 0 );
   ArrayInitialize( _3, 0 );
   ArrayInitialize( _4, 0 );
   ArrayInitialize( _5, 0 );
   ArrayInitialize( _6, 0 );
   ArrayInitialize( _7, 0 );
   ArrayInitialize( _8, 0 );
   ArrayInitialize( _9, 0 );
   ArrayInitialize( _10, 0 );
   return;
}//+------------------------------------------------------------------+


void storeSeriesArrays( int clusterSize, int nrOfBernSeries, int val )
{
   if( _type == 0 ) return;
   switch( clusterSize )
   {
      case 1:  _1[ nrOfBernSeries ] = val; break;
      case 2:  _2[ nrOfBernSeries ] = val; break;
      case 3:  _3[ nrOfBernSeries ] = val; break;
      case 4:  _4[ nrOfBernSeries ] = val; break;
      case 5:  _5[ nrOfBernSeries ] = val; break;
      case 6:  _6[ nrOfBernSeries ] = val; break;
      case 7:  _7[ nrOfBernSeries ] = val; break;
      case 8:  _8[ nrOfBernSeries ] = val; break;
      case 9:  _9[ nrOfBernSeries ] = val; break;
      case 10: _10[ nrOfBernSeries ] = val; break;

      default: break;
   }
   return;
}//+------------------------------------------------------------------+


//         _what
//     
void formHistogram( int seq[], int& histogram[], int& handle, int nr )
{
   string res = DoubleToStr( nr, 0 ) + ",";
   int size = ArraySize( seq );
   int column;
   int max = getLongest( seq );
   res = res + DoubleToStr( max, 0 ) + ",";
   ArrayResize( histogram, max );
   for( int i = 1; i <= max; i ++ )
   {
      column = getQuantityHistogr( seq, i ); 
      histogram[ i - 1 ] = column;
      storeSeriesArrays( i, nr, column ); //    10 , .. 
                                          //     1  10
      res = res + DoubleToStr( column, 0 ) + ",";
   }

   FileWrite( handle, res );   
   return;
}//+------------------------------------------------------------------+


//     (+-1   )
int genBernTest( double probab )
{
   int rnd = MathRand();
   if( rnd < probab * 32767 ) return(  _what );
   else                       return( -_what );  
}



//             
//    
void genSynthHistogr( int& h, int nr )
{
   ArrayResize( _resSynth, _testsTotal );
   for( int i = 0; i < _testsTotal; i ++ )  _resSynth[ i ] = genBernTest( _probab );
   formClustersArray( _resSynth, _seqSynth, h, nr );
   formHistogram(              _seqSynth, _histogramSynth, h, nr );
   return;
}//+------------------------------------------------------------------+


void allArraysWriteToFile( int& h )
{
   writeArrayToFile( _1, h, "1" );  
   writeArrayToFile( _2, h, "2" );  
   writeArrayToFile( _3, h, "3" );  
   writeArrayToFile( _4, h, "4" );  
   writeArrayToFile( _5, h, "5" );  
   writeArrayToFile( _6, h, "6" );  
   writeArrayToFile( _7, h, "7" );  
   writeArrayToFile( _8, h, "8" );  
   writeArrayToFile( _9, h, "9" );  
   writeArrayToFile( _10, h, "10" );  

   return;
}//+------------------------------------------------------------------+

/*
  - :    src[]. ,   
     .   
  ,    ,  _columnsInHistogram, 
    .
*/
void makeHistogram2( int src[], int& h, int nr )
{
   int lefts[]; //     
   int vals[]; //   
   
   //      ( )
   int max = src[ ArrayMaximum( src ) ];
   int min = src[ ArrayMinimum( src ) ];
   
   //   (  )
   int delta = MathCeil( ( max - min ) / ( _colsInHisto - 1) );

   //      
   ArrayResize( lefts, _colsInHisto );
   for( int i = 0; i < _colsInHisto; i ++ )   lefts[ i ] = min + i * delta;
     
   //    
   int left, right;  //      
   int qty = 0;      //     
   ArrayResize( vals, _colsInHisto );
   for( int j = 0; j < _colsInHisto; j ++ )
   {
      left = min + j * delta;
      right = left + delta;
      for( int k = left; k < right; k ++ )   qty += getQuantityHistogr( src, k );
      vals[ j ] = qty;
      qty = 0;   
   }
   
   double sum1 = 0;
   for( int l = 0; l < _globalSeriesQty; l ++ ) sum1 += src[ l ];
   double mean = sum1 / _globalSeriesQty;
   
   double sum2 = 0;
   for( int m = 0; m < _globalSeriesQty; m ++ ) 
      sum2 += ( src[ m ] - mean ) * ( src[ m ] - mean );
   
   double stddev = MathSqrt( sum2 / ( _globalSeriesQty - 1) );   
   
   if( stddev != 0 )     _nrOfHistograms ++;
   else                 return;
   
   writeArrayToFile( lefts, h, DoubleToStr( nr, 0 ) );
   writeArrayToFile( vals, h, DoubleToStr( nr, 0 ) );
   FileWrite( h, " " + 
                 DoubleToStr( nr, 0 ) + "-   : " +
                 DoubleToStr( _histogramReal[ nr - 1 ], 0 ) );
   FileWrite( h, "  - " + DoubleToStr( nr, 0 ) + 
                 "-   : " + DoubleToStr( mean, 5 ) );
   FileWrite( h, "  = " + DoubleToStr( stddev, 5 ) );
   
   double dev = ( _histogramReal[ nr - 1 ] - mean ) / stddev;
   
   _meanDevAbs += MathAbs( dev );
   _meanDev += dev;
   
   FileWrite( h, "      = " + 
                 DoubleToStr( dev, 2 ) + " ..." );
   
   string result;
   if( MathAbs( dev ) < 2 )   result = " ";
   else                       result = "";
   if( result == "" ) _outliers += 1;
   FileWrite( h, "   0.05 (~2 ...)    " +
                  "  -     " + result );
   FileWrite( h, "" );                             
   return;
}//+------------------------------------------------------------------+



int start()
{
   MathSrand( GetTickCount() );  //  ,    
   int h = FileOpen( "Sequences\\histo" + _fname + "_" +
                     DoubleToStr( _what, 0 ) + ".csv", FILE_CSV | FILE_WRITE, "," );
   
   //       
   readIntoArray();
   formClustersArray( _res, _seq, h, 1 );
   formHistogram(         _seq, _histogramReal, h, 1 );
   
   _type = 1;   //     
    
   //      .     
   allArraysPrepare();
   for( int i = 0; i < _globalSeriesQty; i ++ )    
   {
      genSynthHistogr( h, i );
      if( i % 100 == 0 )  Comment( i ); 
   }
   //allArraysWriteToFile( h );
   FileWrite( h, "---------------------------------------------" );
   
   //      , . 81.  
   //    3,   .    
   // (>=5  , ..      1000).
   _colsInHisto = MathFloor( 0.75 * MathPow( _globalSeriesQty, 0.4 ) );
   if ( _colsInHisto % 2 == 0 )  _colsInHisto --;
   
   makeHistogram2( _1, h, 1 );
   makeHistogram2( _2, h, 2 );
   makeHistogram2( _3, h, 3 );
   makeHistogram2( _4, h, 4 );
   makeHistogram2( _5, h, 5 );
   makeHistogram2( _6, h, 6 );
   makeHistogram2( _7, h, 7 );
   makeHistogram2( _8, h, 8 );
   makeHistogram2( _9, h, 9 );
   makeHistogram2( _10, h, 10 );
   
   FileWrite( h, "   = " + 
                 DoubleToStr( _meanDevAbs / _nrOfHistograms, 2 ) );
   FileWrite( h, "  = " + 
                 DoubleToStr( _meanDev / _nrOfHistograms, 2 ) );
   FileWrite( h, "  = " + 
                 DoubleToStr( ( _outliers + 0.0 ) / _nrOfHistograms, 2 ) );
   
   FileClose( h );
   return(0);
}//+------------------------------------------------------------------+