//+------------------------------------------------------------------+
//|                                                   Instrument.mq4 |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 Black
#property indicator_color2 Gray
//---- input parameters
//extern int       Period;
//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_HISTOGRAM,0,2);
   SetIndexBuffer(0,ExtMapBuffer1);
   
   SetIndexStyle(1,DRAW_HISTOGRAM,0,2);
   SetIndexBuffer(1,ExtMapBuffer2);
   
   ArrayInitialize(ExtMapBuffer1,0.0);
   ArrayInitialize(ExtMapBuffer2,0.0);
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
bool isBlack(int shift)
{
   if (Open[shift] > Close[shift])
      return (true);
   return (false);
}
//+------------------------------------------------------------------+
bool isWhite(int shift)
{
   if (Open[shift] < Close[shift]) 
      return (true);
   return (false);
}
//+------------------------------------------------------------------+
int start()
  {
  
//EXAMPLE 1
      //Calculate black and white candles
      double BlackCandlesCount = 0;
      double WhiteCandlesCount = 0;
      double BProbability = 0;

      for (int i = 0; i<Bars-1; i++)
      {
          if (isBlack(i) == true)
            BlackCandlesCount++;

          if (isWhite(i) == true)
            WhiteCandlesCount++;
      }
      
      BProbability = BlackCandlesCount / Bars; 
      
      
//EXAMPLE 2
      //Calculate seqences of 1st order
      //BW means after black going white candle     
      double BW = 0;
      double WB = 0;
      double BB = 0;
      double WW = 0;
      
      
      
      for (i = Bars; i>0; i--)
      {
         if ( isBlack(i) && isWhite(i-1) ) BW++;           
         if ( isWhite(i) && isBlack(i-1) ) WB++;
         if ( isBlack(i) && isBlack(i-1) ) BB++;            
         if ( isWhite(i) && isWhite(i-1) ) WW++;
      }      

//EXAMPLE 3.1
      //Build histogram by RSI
      //RSI min/max - 0/100
      
      
      double RSIHistogramBlack[100];
      double RSIHistogramWhite[100];
      
      for (i = Bars; i>0; i--)
      {
         int rsi_val = iRSI(NULL,0,12,PRICE_CLOSE,i);
      
         if (isWhite(i))
           RSIHistogramWhite[rsi_val]++;
           
         if (isBlack(i))
           RSIHistogramBlack[rsi_val]++;
           
      }

      
      for (i = 0; i<100; i++)
      {
         ExtMapBuffer1[i] = RSIHistogramBlack[i];
         ExtMapBuffer2[i] = -RSIHistogramWhite[i];
      }


//EXAMPLE 3.2
      //Build histogram by %R
      //%R min/max - 0/-100
      
      
      double WPRHistogramBlack[100];
      double WPRHistogramWhite[100];
      
      for (i = Bars; i>0; i--)
      {
         int wpr_val = iWPR(NULL,0,12,i);
      
         int idx = MathAbs(wpr_val);
         if (isWhite(i))
           WPRHistogramWhite[idx]++;
           
         if (isBlack(i))
           WPRHistogramBlack[idx]++;
           
      }

      
      for (i = 0; i<100; i++)
      {
         ExtMapBuffer1[i] = -RSIHistogramBlack[i];
         ExtMapBuffer2[i] = RSIHistogramWhite[i];
         
         ExtMapBuffer1[i+100] = -WPRHistogramBlack[i];
         ExtMapBuffer2[i+100] = WPRHistogramWhite[i];
         
      }

      

//  \\

      Comment(
         "\n"
         ,"Total Black ", BlackCandlesCount,"\n"
         ,"Total White ", WhiteCandlesCount,"\n"
         ,"Black Probability ", BProbability*100," %\n"
         ,"White Probability ", (1-BProbability)*100," %\n"
         ,"\n"
         ,"BW Probability ", (BW/Bars)*100," %\n"         
         ,"WB Probability ", (WB/Bars)*100," %\n"         
         ,"BB Probability ", (BB/Bars)*100," %\n"         
         ,"WW Probability ", (WW/Bars)*100," %\n"         
         );
//  \\         
       
       
         
      
      
   return(0);
  }
//+------------------------------------------------------------------+