from fastapi import FastAPI, HTTPException
from pydantic import BaseModel
from tic_tac_toe import TicTacToe


app = FastAPI()
games = {}

class GameBoard(BaseModel):
    board: list
    player_turn: str

class PlayerMove(BaseModel):
    row: int
    col: int

@app.get("/start-game/")
def start_game():
    game_id = len(games) + 1
    game = TicTacToe()
    games[game_id] = game
    return {"game_id": game_id}

@app.post("/play/{game_id}/")
def play(game_id: int, move: PlayerMove):
    game = games.get(game_id)
    if not game:
        raise HTTPException(status_code=404, detail="Game not found")

    try:
        game.make_move(move.row, move.col)
    except ValueError as e:
        raise HTTPException(status_code=400, detail=str(e))

    # Use the print_board method to print the current game state
    game.print_board()

    return {
        "board": game.board,
        "player_turn": game.player_turn,
    }

if __name__ == "__main__":
    import uvicorn
    uvicorn.run(app, host="0.0.0.0", port=8000)