//+------------------------------------------------------------------+
//|                                                        deals.mq5 |
//|                                  Copyright 2023, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
#include <JAson.mqh>

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnStart()
  {
//--- request trade history
   HistorySelect(0, TimeCurrent());
   int deals_total = HistoryDealsTotal();

   CJAVal data;
   CJAVal deals;
   for(int i = 0; i < deals_total; i++)
     {
      //-- integers
      ulong deal_ticket = HistoryDealGetTicket(i);

      data["ticket"] = (int) deal_ticket;
      data["order"] = (int) HistoryDealGetInteger(deal_ticket, DEAL_ORDER);
      data["position"] = (int) HistoryDealGetInteger(deal_ticket, DEAL_POSITION_ID);
      data["time"] = (int) HistoryDealGetInteger(deal_ticket, DEAL_TIME);
      data["type"] = (int) HistoryDealGetInteger(deal_ticket, DEAL_TYPE);
      data["entry"] = (int) HistoryDealGetInteger(deal_ticket, DEAL_ENTRY);
      data["magic"] = (int) HistoryDealGetInteger(deal_ticket, DEAL_MAGIC);
      data["reason"] = (int) HistoryDealGetInteger(deal_ticket, DEAL_REASON);
      //--- strings
      data["symbol"] = (string) HistoryDealGetString(deal_ticket, DEAL_SYMBOL);
      //--- doubles
      data["volume"] = (double) HistoryDealGetDouble(deal_ticket, DEAL_VOLUME);
      data["price"] = (double) HistoryDealGetDouble(deal_ticket, DEAL_PRICE);
      data["profit"] = (double) HistoryDealGetDouble(deal_ticket, DEAL_PROFIT);
      data["swap"] = (double) HistoryDealGetDouble(deal_ticket, DEAL_SWAP);
      data["comission"] = (double) HistoryDealGetDouble(deal_ticket, DEAL_COMMISSION);


      deals["deals"].Add(data);

      //Print(deals.Serialize());
     }

//--- correct way of working in the "file sandbox"
   ResetLastError();
   string terminal_data_path = TerminalInfoString(TERMINAL_DATA_PATH);
   string subfolder = "TutoPostgres";
   int filehandle = FileOpen(subfolder + "\\deals.json", FILE_WRITE);

   if(filehandle != INVALID_HANDLE)
     {
      FileWrite(filehandle, deals.Serialize());
      FileClose(filehandle);
      Print("The file must be created in the folder " + terminal_data_path + "\\" + subfolder);
     }
   else
      Print("File open failed, error ", GetLastError());

  }
//+------------------------------------------------------------------+
//--- {"deals":[{"ticket":1584100688,"order":0,"position":0,"time":1677126344,"type":2,"entry":0,"magic":0,"reason":0,"symbol":null,"volume":0.00000000,"price":0.00000000,"profit":10000.00000000,"swap":0.00000000,"comission":0.00000000},{"ticket":1584135832,"order":1606431288,"position":1606431288,"time":1677130297,"type":0,"entry":0,"magic":0,"reason":0,"symbol":"GBPUSD","volume":0.01000000,"price":1.20643000,"profit":0.00000000,"swap":0.00000000,"comission":0.00000000},{"ticket":1584156730,"order":1606445642,"

//+------------------------------------------------------------------+
