//+------------------------------------------------------------------+
//|                                                         accs.mq5 |
//|                                  Copyright 2023, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"

#include <JAson.mqh>
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {  
     CJAVal data;
     //--- doubles
     data["balance"] = AccountInfoDouble(ACCOUNT_BALANCE);
     data["credit"] = AccountInfoDouble(ACCOUNT_CREDIT);
     data["profit"] = AccountInfoDouble(ACCOUNT_PROFIT);
     data["equity"] = AccountInfoDouble(ACCOUNT_EQUITY);
     data["margin"] = AccountInfoDouble(ACCOUNT_MARGIN);
     data["margin_free"] = AccountInfoDouble(ACCOUNT_MARGIN_FREE);
     data["margin_level"] = AccountInfoDouble(ACCOUNT_MARGIN_LEVEL);
     data["margin_so_call"] = AccountInfoDouble(ACCOUNT_MARGIN_SO_CALL);
     data["margin_so_so"] = AccountInfoDouble(ACCOUNT_MARGIN_SO_SO);
     //--- integers
     data["login"] = AccountInfoInteger(ACCOUNT_LOGIN);
     data["leverage"] = AccountInfoInteger(ACCOUNT_LEVERAGE);
     data["trade_allowed"] = AccountInfoInteger(ACCOUNT_TRADE_ALLOWED);
     data["ea_allowed"] = AccountInfoInteger(ACCOUNT_TRADE_EXPERT);
     data["trade_mode"] = AccountInfoInteger(ACCOUNT_TRADE_MODE);
     data["margin_so_mode"] = AccountInfoInteger(ACCOUNT_MARGIN_SO_MODE);
     //-- strings
     data["company"] = AccountInfoString(ACCOUNT_COMPANY);
     data["currency"] = AccountInfoString(ACCOUNT_CURRENCY);
     data["name"] = AccountInfoString(ACCOUNT_NAME);
     data["server"] = AccountInfoString(ACCOUNT_SERVER);
     
     CJAVal acc_info;
     acc_info["acc_info"].Add(data);
    
     //Print(acc_info.Serialize());
     //--- correct way of working in the "file sandbox"
   ResetLastError();
   string terminal_data_path = TerminalInfoString(TERMINAL_DATA_PATH);
   string subfolder = "TutoPostgres";
   int filehandle = FileOpen(subfolder + "\\accs.json", FILE_WRITE);

   if(filehandle != INVALID_HANDLE)
     {
      FileWrite(filehandle, acc_info.Serialize());
      FileClose(filehandle);
      Print("The file must be created in the folder " + terminal_data_path + "\\" + subfolder);
     }
   else
      Print("File open failed, error ", GetLastError());
  }
//+------------------------------------------------------------------+
//{"acc_info":[{"balance":10005.93000000,"credit":0.00000000,"profit":0.00000000,"equity":10005.93000000,"margin":0.00000000,"margin_free":10005.93000000,"margin_level":0.00000000,"margin_so_call":50.00000000,"margin_so_so":30.00000000,"login":66744794,"leverage":100,"trade_allowed":1,"ea_allowed":1,"trade_mode":0,"margin_so_mode":0,"company":"MetaQuotes Software Corp.","currency":"USD","name":"MetaTrader 5 Desktop Demo","server":"MetaQuotes-Demo"}]}
