//+------------------------------------------------------------------+
//|                                                   post_deals.mq5 |
//|                                  Copyright 2023, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"

#include <JAson.mqh> //--- include the JSON library
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//--- gathering the data - Deals
   CJAVal data;
   CJAVal deals;

//--- request trade history
   HistorySelect(0, TimeCurrent());
   int deals_total = HistoryDealsTotal();

//--- iterate over all deals to get data
//--- of each deal from its ticket number
   for(int i = 0; i < deals_total; i++)
     {
      //-- integers
      ulong deal_ticket = HistoryDealGetTicket(i);

      data["ticket"] = (int) deal_ticket;
      data["order"] = (int) HistoryDealGetInteger(deal_ticket, DEAL_ORDER);
      data["position"] = (int) HistoryDealGetInteger(deal_ticket, DEAL_POSITION_ID);
      data["time"] = (int) HistoryDealGetInteger(deal_ticket, DEAL_TIME);
      data["type"] = (int) HistoryDealGetInteger(deal_ticket, DEAL_TYPE);
      data["entry"] = (int) HistoryDealGetInteger(deal_ticket, DEAL_ENTRY);
      data["magic"] = (int) HistoryDealGetInteger(deal_ticket, DEAL_MAGIC);
      data["reason"] = (int) HistoryDealGetInteger(deal_ticket, DEAL_REASON);
      //--- strings
      data["symbol"] = (string) HistoryDealGetString(deal_ticket, DEAL_SYMBOL);
      //--- doubles
      data["volume"] = (double) HistoryDealGetDouble(deal_ticket, DEAL_VOLUME);
      data["price"] = (double) HistoryDealGetDouble(deal_ticket, DEAL_PRICE);
      data["profit"] = (double) HistoryDealGetDouble(deal_ticket, DEAL_PROFIT);
      data["swap"] = (double) HistoryDealGetDouble(deal_ticket, DEAL_SWAP);
      data["comission"] = (double) HistoryDealGetDouble(deal_ticket, DEAL_COMMISSION);

 //--- fill in the deals array with each deal data
      deals["deals"].Add(data);
     }
 //--- WebRequest arguments
   string method = "POST";
   string url = "http://172.22.18.235/deals";
   string headers = "Content-Type: application/json";
   int timeout = 500;
   char post[], result[];
   string result_headers;
   
 //--- prepare JSON data to send
   string json = deals.Serialize();
   ArrayResize(post, json.Length(), 0);
   StringToCharArray(json, post, 0, StringLen(json), CP_UTF8);

   ResetLastError();

//--- send the request
   int res = WebRequest(method, url, headers, timeout, post, result, result_headers);
   
   if(res == -1)
     {
      Print("Error in WebRequest  =", GetLastError());
      MessageBox("Add " + url + " to allowed URLs on MT5 terminal", "Unknown URL", MB_ICONINFORMATION);     }
   else
     {
      Print("Starting post...");
      
      if(res == 201)// HTTP result code 201 (created)
        {
         Print("posted deals");
        }
     }
  }
//+------------------------------------------------------------------+
//|              sample generated JSON                               |
//+------------------------------------------------------------------+

//[{"balance":10005.93000000,"credit":0.00000000,"profit":0.00000000,"equity":10005.93000000,"margin":0.00000000,"margin_free":10005.93000000,"margin_level":0.00000000,"margin_so_call":50.00000000,"margin_so_so":30.00000000,"login":66744794,"leverage":100,"trade_allowed":1,"ea_allowed":1,"trade_mode":0,"margin_so_mode":0,"company":"MetaQuotes Software Corp.","currency":"USD","name":"MetaTrader 5 Desktop Demo","server":"MetaQuotes-Demo"}]
