//+------------------------------------------------------------------+
//|                                                post_acc_info.mq5 |
//|                                  Copyright 2023, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"

#include <JAson.mqh> //--- include the JSON library
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//--- gathering the data - Account Info
   CJAVal data;
   CJAVal acc_info;

//--- doubles
   data["balance"] = AccountInfoDouble(ACCOUNT_BALANCE);
   data["credit"] = AccountInfoDouble(ACCOUNT_CREDIT);
   data["profit"] = AccountInfoDouble(ACCOUNT_PROFIT);
   data["equity"] = AccountInfoDouble(ACCOUNT_EQUITY);
   data["margin"] = AccountInfoDouble(ACCOUNT_MARGIN);
   data["margin_free"] = AccountInfoDouble(ACCOUNT_MARGIN_FREE);
   data["margin_level"] = AccountInfoDouble(ACCOUNT_MARGIN_LEVEL);
   data["margin_so_call"] = AccountInfoDouble(ACCOUNT_MARGIN_SO_CALL);
   data["margin_so_so"] = AccountInfoDouble(ACCOUNT_MARGIN_SO_SO);
//--- integers
   data["login"] = AccountInfoInteger(ACCOUNT_LOGIN);
   data["leverage"] = AccountInfoInteger(ACCOUNT_LEVERAGE);
   data["trade_allowed"] = AccountInfoInteger(ACCOUNT_TRADE_ALLOWED);
   data["ea_allowed"] = AccountInfoInteger(ACCOUNT_TRADE_EXPERT);
   data["trade_mode"] = AccountInfoInteger(ACCOUNT_TRADE_MODE);
   data["margin_so_mode"] = AccountInfoInteger(ACCOUNT_MARGIN_SO_MODE);
//-- strings
   data["company"] = AccountInfoString(ACCOUNT_COMPANY);
   data["currency"] = AccountInfoString(ACCOUNT_CURRENCY);
   data["name"] = AccountInfoString(ACCOUNT_NAME);
   data["server"] = AccountInfoString(ACCOUNT_SERVER);
   
//--- fill in the acc_info array with Account Info data
   acc_info["acc_info"].Add(data);
   
//--- WebRequest arguments
   string method = "POST";
   string url = "http://172.20.155.236/accs";
   string headers = "Content-Type: application/json";
   int timeout = 500;
   char post[], result[];
   string result_headers;
   
//--- prepare JSON data to send
   string json = acc_info.Serialize();
   ArrayResize(post, json.Length(), 0);
   StringToCharArray(json, post, 0, StringLen(json), CP_UTF8);

   ResetLastError();
   
//--- send the request
   int res = WebRequest(method, url, headers, timeout, post, result, result_headers);
   if(res == -1)
     {
      Print("Error in WebRequest  =", GetLastError());
      MessageBox("Add " + url + " to allowed URLs on MT5 terminal", "Unknown URL", MB_ICONINFORMATION);     }
   else
     {
      Print("Starting post...");
      
      if(res == 201)// HTTP result code 201 (created)
        {
         Print("posted accs");
        }
     }
  }
//+------------------------------------------------------------------+
//|              sample generated JSON                               |
//+------------------------------------------------------------------+

//[{"balance":10005.93000000,"credit":0.00000000,"profit":0.00000000,"equity":10005.93000000,"margin":0.00000000,"margin_free":10005.93000000,"margin_level":0.00000000,"margin_so_call":50.00000000,"margin_so_so":30.00000000,"login":66744794,"leverage":100,"trade_allowed":1,"ea_allowed":1,"trade_mode":0,"margin_so_mode":0,"company":"MetaQuotes Software Corp.","currency":"USD","name":"MetaTrader 5 Desktop Demo","server":"MetaQuotes-Demo"}]
