//+------------------------------------------------------------------+
//|                                           dStandByMatrixMult.mq5 |
//|                                           Copyright 2022, denkir |
//|                             https://www.mql5.com/ru/users/denkir |
//+------------------------------------------------------------------+
#property service
#property copyright "Copyright 2022, denkir"
#property link      "https://www.mql5.com/ru/users/denkir"
#property version   "1.00"
//+------------------------------------------------------------------+
//| Service program start function                                   |
//+------------------------------------------------------------------+
void OnStart()
  {
   string program_name=::MQLInfoString(MQL_PROGRAM_NAME);
   datetime now=::TimeLocal();
   ::PrintFormat("Service \"%s\" starts at: %s", program_name,
                 ::TimeToString(now, TIME_DATE|TIME_SECONDS));
   do
     {
      ::Sleep(1);
     }
   while(!::IsStopped());
   now=::TimeLocal();
   ::PrintFormat("Service \"%s\" stops at: %s", program_name,
                 ::TimeToString(now, TIME_DATE|TIME_SECONDS));
//--- final goodbye
   for(ushort cnt=0; cnt<5; cnt++)
     {
      ::PrintFormat("Count: %hu", cnt+1);
      ::Sleep(10000);
     }
//--- Matrix mult
//--- matrix A 1000x2000
   int rows_a=1000;
   int cols_a=2000;
//--- matrix B 2000x1000
   int rows_b=cols_a;
   int cols_b=1000;
//--- matrix C 1000x1000
   int rows_c=rows_a;
   int cols_c=cols_b;
//--- matrix A: size=rows_a*cols_a
   int size_a=rows_a*cols_a;
   int size_b=rows_b*cols_b;
   int size_c=rows_c*cols_c;
//--- prepare matrix A
   double matrix_a[];
   ::ArrayResize(matrix_a, rows_a*cols_a);
   for(int i=0; i<rows_a; i++)
      for(int j=0; j<cols_a; j++)
         matrix_a[i*cols_a+j]=(double)(10*::MathRand()/32767);
//--- prepare matrix B
   double matrix_b[];
   ::ArrayResize(matrix_b, rows_b*cols_b);
   for(int i=0; i<rows_b; i++)
      for(int j=0; j<cols_b; j++)
         matrix_b[i*cols_b+j]=(double)(10*::MathRand()/32767);
//--- CPU: calculate matrix product matrix_a*matrix_b
   double matrix_c_cpu[];
   ulong time_cpu=0;
   if(!MatrixMult_CPU(matrix_a, matrix_b, matrix_c_cpu, rows_a, cols_a, cols_b, time_cpu))
     {
      ::PrintFormat("Error in calculation on CPU. Error code=%d", ::GetLastError());
      return;
     }
   ::PrintFormat("time CPU=%d ms", time_cpu);
  }
//+------------------------------------------------------------------+
//| MatrixMult_CPU                                                   |
//+------------------------------------------------------------------+
bool MatrixMult_CPU(const double &matrix_a[], const double &matrix_b[], double &matrix_c[],
                    const int rows_a, const int cols_a, const int cols_b, ulong &time_cpu)
  {
   int size=rows_a*cols_b;
   if(::ArrayResize(matrix_c, size)!=size)
      return false;
//--- CPU calculation started
   time_cpu=::GetMicrosecondCount();
   for(int i=0; i<rows_a; i++)
     {
      for(int j=0; j<cols_b; j++)
        {
         double sum=0.0;
         for(int k=0; k<cols_a; k++)
           {
            sum+=matrix_a[cols_a*i+k]*matrix_b[cols_b*k+j];
           }
         matrix_c[cols_b*i+j]=sum;
        }
     }
//--- CPU calculation finished
   time_cpu=ulong((::GetMicrosecondCount()-time_cpu)/1000);
//---
   return true;
  }
//+------------------------------------------------------------------+
