//+------------------------------------------------------------------+
//|                                       dActivePositionsCharts.mq5 |
//|                                           Copyright 2022, denkir |
//|                             https://www.mql5.com/ru/users/denkir |
//+------------------------------------------------------------------+
#property service
#property copyright "Copyright 2022, denkir"
#property link      "https://www.mql5.com/ru/users/denkir"
#property version   "1.00"
//--- include
#include <Trade\PositionInfo.mqh>
#include <Charts\Chart.mqh>
#include <Generic\HashSet.mqh>
#include <Generic\HashMap.mqh>
#include <WinAPI\winapi.mqh>
#include <VirtualKeys.mqh>
//--- defines
#define KEYEVENTF_KEYUP 0x0002
#define MAX_CHARTS 100
//+------------------------------------------------------------------+
//| Service program start function                                   |
//+------------------------------------------------------------------+
void OnStart()
  {
   string program_name=::MQLInfoString(MQL_PROGRAM_NAME);
   datetime now=::TimeLocal();
   ::PrintFormat("Service \"%s\" starts at: %s", program_name,
                 ::TimeToString(now, TIME_DATE|TIME_SECONDS));
//--- main processing loop
   do
     {
      int positions_num=::PositionsTotal();
      //--- if there are no positions
      if(positions_num<1)
        {
         // close all the charts
         CChart temp_chart_obj;
         temp_chart_obj.FirstChart();
         long temp_ch_id=temp_chart_obj.ChartId();
         for(int ch_idx=0; ch_idx<MAX_CHARTS && temp_ch_id>-1; ch_idx++)
           {
            long ch_id_to_close=temp_ch_id;
            temp_chart_obj.NextChart();
            temp_ch_id=temp_chart_obj.ChartId();
            ::ChartClose(ch_id_to_close);
           }
        }
      //--- if there are some positions
      else
        {
         //--- collect unique position symbols
         CHashSet<string> pos_symbols_set;
         for(int pos_idx=0; pos_idx<positions_num; pos_idx++)
           {
            string curr_pos_symbol=::PositionGetSymbol(pos_idx);
            if(!pos_symbols_set.Contains(curr_pos_symbol))
              {
               if(!pos_symbols_set.Add(curr_pos_symbol))
                  ::PrintFormat("Failed to add a symbol \"%s\" to the positions set!", curr_pos_symbol);
              }
           }
         string pos_symbols_arr[];
         int unique_pos_symbols_num=pos_symbols_set.Count();
         if(pos_symbols_set.CopyTo(pos_symbols_arr)!=unique_pos_symbols_num)
            continue;
         //--- collect unique chart symbols and close duplicates
         CHashMap<string, long> ch_symbols_map;
         CChart map_chart_obj;
         map_chart_obj.FirstChart();
         long map_ch_id=map_chart_obj.ChartId();
         for(int ch_idx=0; ch_idx<MAX_CHARTS && map_ch_id>-1; ch_idx++)
           {
            string curr_ch_symbol=map_chart_obj.Symbol();
            long ch_id_to_close=0;
            if(!ch_symbols_map.ContainsKey(curr_ch_symbol))
              {
               if(!ch_symbols_map.Add(curr_ch_symbol, map_ch_id))
                  ::PrintFormat("Failed to add a symbol \"%s\" to the charts map!", curr_ch_symbol);
              }
            else
              {
               //--- if there's a duplicate
               ch_id_to_close=map_chart_obj.ChartId();
              }
            //--- move to the next chart
            map_chart_obj.NextChart();
            map_ch_id=map_chart_obj.ChartId();
            if(ch_id_to_close>0)
              {
               ::ChartClose(ch_id_to_close);
              }
           }
         map_chart_obj.Detach();
         //--- looking for a chart if there's a position
         for(int s_pos_idx=0; s_pos_idx<unique_pos_symbols_num; s_pos_idx++)
           {
            string curr_pos_symbol=pos_symbols_arr[s_pos_idx];
            //--- if there's no chart of the symbol
            if(!ch_symbols_map.ContainsKey(curr_pos_symbol))
               if(::SymbolSelect(curr_pos_symbol, true))
                 {
                  //--- open a chart of the symbol
                  CChart temp_chart_obj;
                  long temp_ch_id=temp_chart_obj.Open(curr_pos_symbol, PERIOD_H1);
                  if(temp_ch_id<1)
                     ::PrintFormat("Failed to open a chart of the symbol \"%s\"!", curr_pos_symbol);
                  else
                    {
                     if(!ch_symbols_map.Add(curr_pos_symbol, temp_ch_id))
                        ::PrintFormat("Failed to add a symbol \"%s\" to the charts map!", curr_pos_symbol);
                     temp_chart_obj.Detach();
                    }
                 }
           }
         string ch_symbols_arr[];
         long ch_ids_arr[];
         int unique_ch_symbols_num=ch_symbols_map.Count();
         if(ch_symbols_map.CopyTo(ch_symbols_arr, ch_ids_arr)!=unique_ch_symbols_num)
            continue;
         //--- looking for a position if there's a chart
         for(int s_ch_idx=0; s_ch_idx<unique_ch_symbols_num; s_ch_idx++)
           {
            string curr_ch_symbol=ch_symbols_arr[s_ch_idx];
            long ch_id_to_close=ch_ids_arr[s_ch_idx];
            CChart temp_chart_obj;
            temp_chart_obj.Attach(ch_id_to_close);
            //--- if there's no position of the symbol
            if(!pos_symbols_set.Contains(curr_ch_symbol))
              {
               temp_chart_obj.Close();
              }
            else
              {
               CPositionInfo curr_pos_info;
               //--- calculate  a position profit
               double curr_pos_profit=0.;
               int pos_num=::PositionsTotal();
               for(int pos_idx=0; pos_idx<pos_num; pos_idx++)
                  if(curr_pos_info.SelectByIndex(pos_idx))
                    {
                     string curr_pos_symbol=curr_pos_info.Symbol();
                     if(!::StringCompare(curr_ch_symbol, curr_pos_symbol))
                        curr_pos_profit+=curr_pos_info.Profit()+curr_pos_info.Swap();
                    }
               //--- apply a color
               color profit_clr=clrLavender;
               if(curr_pos_profit>0.)
                 {
                  profit_clr=clrLightSkyBlue;
                 }
               else if(curr_pos_profit<0.)
                 {
                  profit_clr=clrLightPink;
                 }
               if(!temp_chart_obj.ColorBackground(profit_clr))
                  ::PrintFormat("Failed to apply a profit color for the symbol \"%s\"!", curr_ch_symbol);
               temp_chart_obj.Redraw();
              }
            temp_chart_obj.Detach();
           }
         //--- tile windows (Alt+R)
         uchar vk=VK_MENU;
         uchar scan=0;
         uint flags[]= {0, KEYEVENTF_KEYUP};
         ulong extra_info=0;
         uchar Key='R';
         for(int r_idx=0; r_idx<2; r_idx++)
           {
            user32::keybd_event(vk, scan, flags[r_idx], extra_info);
            ::Sleep(10);
            user32::keybd_event(Key, scan, flags[r_idx], extra_info);
           }
        }
      ::Sleep(3000);
     }
   while(!::IsStopped());
   now=::TimeLocal();
   ::PrintFormat("Service \"%s\" stops at: %s", program_name,
                 ::TimeToString(now, TIME_DATE|TIME_SECONDS));
  }
//+------------------------------------------------------------------+
